<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Soal extends CI_Controller
{
    public function __construct() 
    {
        parent::__construct();
        $this->load->library(['session', 'form_validation']);
        $this->load->helper(['form', 'url']);
        $this->load->model('m_data');

        if ($this->session->userdata('status') != 'admin_login' && 
            $this->session->userdata('status') != 'guru_login') 
        {
            redirect('auth');
        }
    }

    public function index()
    {
        $data['soal'] = $this->m_data->get_data('tb_matapelajaran')->result();
        $this->load->view('admin/v_soal', $data);
    }

    public function insert()
    {
        $this->db->db_debug = false;
        
        $pertanyaan = $this->input->post('pertanyaan');
        $pertanyaan = preg_replace_callback(
            '/src="(blob:[^"]+)"/',
            function($matches) {
                return 'src="' . str_replace('blob:', '', $matches[1]) . '"';
            },
            $pertanyaan
        );

        $tipe_soal = $this->input->post('tipe_soal');

        $data = 
        [
            'id_matapelajaran' => $this->input->post('nama_matapelajaran'),
            'pertanyaan' => $this->input->post('pertanyaan'), 
            'tipe_soal' => $tipe_soal,
            'a' => $tipe_soal === 'pg' ? $this->input->post('a') : '',
            'b' => $tipe_soal === 'pg' ? $this->input->post('b') : '',
            'c' => $tipe_soal === 'pg' ? $this->input->post('c') : '',
            'd' => $tipe_soal === 'pg' ? $this->input->post('d') : '',
            'e' => $tipe_soal === 'pg' ? $this->input->post('e') : '',
            'kunci_jawaban' => $tipe_soal === 'pg' ? $this->input->post('kunci') : '',
            'created_at' => date('Y-m-d H:i:s')
        ];

        try {
            $this->db->insert('tb_soal_ujian', $data);
            if ($this->db->affected_rows() > 0) 
            {
                $this->session->set_flashdata('message', '<div class="alert alert-success">Soal berhasil disimpan!</div>');
            } else 
            {
                throw new Exception('Tidak ada data yang disimpan');
            }
        } catch (Exception $e) 
        {
            $error = $this->db->error();
            $error_msg = $error['message'] ?? $e->getMessage();
            $this->session->set_flashdata('message', '<div class="alert alert-danger">Error: '.$error_msg.'</div>');
        }

        redirect('soal');
    }
    
    public function upload_image(){
        log_message('error', 'upload_image method called');
        if(isset($_FILES['upload']['name'])){
            $file = $_FILES['upload']['tmp_name'];
            $file_name = $_FILES['upload']['name'];
            $file_name_array = explode(".", $file_name);
            $extension = end($file_name_array);
            $new_image_name = rand() . '.' . $extension;
            
            $upload_path = FCPATH . 'upload/';
            
            if(!is_dir($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            $allowed_extension = array("jpg", "gif", "png");
            if(in_array($extension, $allowed_extension)){
                move_uploaded_file($file, 'upload/' . $new_image_name);
                $function_number = $_GET['CKEditorFuncNum'];
                $url = 'upload/' . $new_image_name;
                $message = '';
                echo "<script type='text/javascript'>window.parent.CKEDITOR.tools.callFunction($function_number, '$url', '$message');</script>";
            }
        }
    }
}
