<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Penilaian_essay extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        
        if ($this->session->userdata('status') != 'admin_login' &&
            $this->session->userdata('status') != 'guru_login') {
            redirect('auth');
        }

        $this->load->database();
        $this->load->helper(['url', 'form']);
    }

    public function index()
    {
        $id_guru = $this->session->userdata('id_guru');

        if (!$id_guru) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger">Session guru tidak ditemukan. Silakan login ulang.</div>');
            redirect('auth');
            return;
        }

        $sql = "
            SELECT je.id_jawaban AS id, s.nama_siswa, su.pertanyaan, je.jawaban, je.nilai_essay 
            FROM tb_jawaban je
            JOIN tb_peserta p ON je.id_peserta = p.id_peserta
            JOIN tb_siswa s ON p.id_siswa = s.id_siswa
            JOIN tb_soal_ujian su ON je.id_soal_ujian = su.id_soal_ujian
            WHERE (je.nilai_essay IS NULL OR je.nilai_essay = '')
        ";

        $query = $this->db->query($sql, [$id_guru]);

        if (!$query) {
            $error = $this->db->error();
            echo "<h3>SQL Error:</h3>";
            echo "<pre>" . $error['message'] . "</pre>";
            echo "<h4>Query yang dijalankan:</h4>";
            echo "<pre>" . $this->db->last_query() . "</pre>";
            exit;
        }

        $data['essay'] = $query->result();

        $this->load->view('admin/v_penilaian_essay', $data); 
    }

    public function nilai_aksi()
    {

        
        $id = $this->input->post('id_jawaban');
        $nilai = $this->input->post('nilai');
        if (!is_numeric($nilai)) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger">Nilai harus berupa angka.</div>');
            redirect('penilaian_essay'); return;
        }
        $nilai = (float) $nilai;

        if (!$id) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger">Gagal menyimpan nilai: ID tidak ditemukan.</div>');
            redirect('penilaian_essay');
            return;
        }

        if ($nilai < 0 || $nilai > 100) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger">Nilai harus antara 0 hingga 100.</div>');
            redirect('penilaian_essay');
            return;
        }

        $update = $this->db->update('tb_jawaban', ['nilai_essay' => $nilai], ['id_jawaban' => $id]);

        if ($update) {
            $this->session->set_flashdata('message', '<div class="alert alert-success">Nilai berhasil disimpan.</div>');
        } else {
            $this->session->set_flashdata('message', '<div class="alert alert-danger">Gagal menyimpan nilai.</div>');
        }

        redirect('penilaian_essay');
    }
}
