<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Home extends MY_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        
        if ($this->session->userdata('status') != 'admin_login') {
            if ($this->session->userdata('status') != 'guru_login') {
                redirect('auth');
            }
        }
    }

    public function index()
    {
        // Get user data safely
        $user_type = $this->get_user_type();
        $user_name = $this->get_session_data('nama');
        
        // Redirect based on user type
        if ($user_type === 'siswa') {
            $this->safe_redirect('home_siswa');
            return;
        }
        
        // Load view for admin/guru
        $data = [
            'title' => 'Dashboard',
            'user_name' => $user_name,
            'user_type' => $user_type,
            'db_status' => $this->use_database
        ];
        
        try {
            $this->load->view('templates/header', $data);
            $this->load->view('home', $data);
            $this->load->view('templates/footer');
        } catch (Exception $e) {
            // If view loading fails, show simple page
            $this->show_simple_dashboard($data);
        }
    }
    
    private function show_simple_dashboard($data)
    {
        echo '<!DOCTYPE html>
<html>
<head>
    <title>Dashboard</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Dashboard - Selamat Datang ' . htmlspecialchars($data['user_name']) . '</h4>
                    </div>
                    <div class="card-body">
                        <p>Status Database: ' . ($data['db_status'] ? 'Terhubung' : 'Mode Demo') . '</p>
                        <p>Level Akses: ' . ucfirst($data['user_type']) . '</p>
                        <a href="' . base_url('auth/logout') . '" class="btn btn-danger">Logout</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>';
    }
}