<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Hasil_ujian extends CI_Controller
{
	public function __construct() {
        parent::__construct();
        $this->load->library('session');
        
        if ($this->session->userdata('status') != 'admin_login' &&
            $this->session->userdata('status') != 'guru_login') {
            redirect('auth');
        }
        $this->load->model('m_hasil');
        $this->load->library('mypdf');
    }

	public function index()
	{
		if (isset($_GET['id'])) {
			$id = $this->input->get('id');
			$data['hasil'] = $this->m_hasil->get_peserta2($id);
			$data['kelas']=$this->m_data->get_data('tb_matapelajaran')->result();
		} else {
			$data['hasil'] = $this->m_hasil->get_peserta3();
			$data['kelas']=$this->m_data->get_data('tb_matapelajaran')->result();
		}		
		$this->load->view('admin/v_hasil', $data);
	}

	public function print_all()
	{	
		if (isset($_GET['id'])) {
			$id = $this->input->get('id');
			$data['cetak'] = $this->m_hasil->get_peserta2($id);
		} else {
			$data['cetak'] = $this->m_hasil->get_peserta3();
		}
		$this->mypdf->generate('admin/v_cetak', $data, 'Cetak Hasil Ujian ujian', 'A4', 'Landscape');
	}

	public function cetak($id)
	{
		$where = array('id_peserta' => $id);
		$id = $where['id_peserta'];
		$data['cetak'] = $this->m_hasil->cetak($id);
		$this->mypdf->generate('admin/v_cetak', $data, 'Cetak Hasil Ujian ujian', 'A4', 'Landscape');
	}

	public function penilaian_essay()
	{
		$data['jawaban'] = $this->m_hasil->get_jawaban_essay();
		$this->load->view('admin/v_penilaian_essay', $data);
	}

	public function nilai_essay_aksi()
	{
		$id_jawaban = $this->input->post('id_jawaban');
		$nilai = $this->input->post('nilai');

		$data = ['nilai_essay' => $nilai];
		$this->m_data->UpdateNilai($id_jawaban, $data);

		$this->session->set_flashdata('message', '<div class="alert alert-success">Nilai essay berhasil disimpan</div>');
		redirect(base_url('hasil_ujian/penilaian_essay'));
	}
}