<?php
// header.php
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?= isset($title) ? $title : 'Sistem Ujian Online' ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <!-- Custom CSS -->
    <style>
        :root {
            --primary-color: #20c997;
            --secondary-color: #6c757d;
            --sidebar-width: 280px;
        }

        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
        }

        .navbar {
            background: linear-gradient(135deg, var(--primary-color), #17a589);
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1030;
            height: 76px;
        }

        .navbar-brand {
            font-weight: bold;
            font-size: 1.5rem;
        }

        .navbar-nav .nav-link {
            color: rgba(255, 255, 255, 0.9) !important;
            font-weight: 500;
            padding: 8px 16px !important;
            border-radius: 6px;
            margin: 0 2px;
            transition: all 0.3s ease;
        }

        .navbar-nav .nav-link:hover {
            background-color: rgba(255, 255, 255, 0.15);
            color: white !important;
        }

        .dropdown-menu {
            border: none;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
            border-radius: 10px;
            padding: 8px 0;
        }

        .dropdown-item {
            padding: 10px 20px;
            font-weight: 500;
        }

        .dropdown-item:hover {
            background-color: var(--primary-color);
            color: white;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            margin-right: 8px;
        }

        /* Main content spacing to avoid navbar overlap */
        .main-content {
            margin-top: 76px;
            padding: 20px 0;
            min-height: calc(100vh - 76px);
        }

        /* Cards and components styling */
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            overflow: hidden;
        }

        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 30px rgba(0,0,0,0.15);
        }

        .card-header {
            background: linear-gradient(135deg, var(--primary-color), #17a589);
            color: white;
            border-radius: 15px 15px 0 0 !important;
            font-weight: 600;
            padding: 20px;
            border: none;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color), #17a589);
            border: none;
            border-radius: 25px;
            padding: 12px 25px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, #17a589, #148a75);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }

        .btn-success {
            background: linear-gradient(135deg, #28a745, #20c997);
            border: none;
            border-radius: 25px;
            padding: 12px 25px;
            font-weight: 600;
        }

        .btn-info {
            background: linear-gradient(135deg, #17a2b8, #20c997);
            border: none;
            border-radius: 25px;
            padding: 12px 25px;
            font-weight: 600;
        }

        .btn-warning {
            background: linear-gradient(135deg, #ffc107, #fd7e14);
            border: none;
            border-radius: 25px;
            padding: 12px 25px;
            font-weight: 600;
        }

        .btn-danger {
            background: linear-gradient(135deg, #dc3545, #c82333);
            border: none;
            border-radius: 25px;
            padding: 12px 25px;
            font-weight: 600;
        }

        .alert {
            border: none;
            border-radius: 10px;
            font-weight: 500;
        }

        .badge {
            font-weight: 600;
            padding: 8px 12px;
            border-radius: 20px;
        }

        /* Footer positioning */
        body {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        .main-content {
            flex: 1;
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .navbar-brand {
                font-size: 1.2rem;
            }
            
            .user-avatar {
                width: 35px;
                height: 35px;
                font-size: 1rem;
            }
        }

        /* Animation classes */
        .fade-in {
            animation: fadeIn 0.6s ease-in-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .pulse {
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.02); }
            100% { transform: scale(1); }
        }
    </style>
</head>
<body>
    <!-- Navigation Bar -->
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container-fluid">
            <button class="btn btn-link text-white d-lg-none" id="sidebarToggle" type="button">
                <i class="fas fa-bars"></i>
            </button>
            
            <a class="navbar-brand" href="<?= isset($base_url) ? $base_url . 'home' : '#' ?>">
                <i class="fas fa-graduation-cap me-2"></i>
                Sistem Ujian Online
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= isset($base_url) ? $base_url . 'home' : '#' ?>">
                            <i class="fas fa-home me-1"></i> Dashboard
                        </a>
                    </li>
                    
                    <?php if(isset($user_type) && $user_type == 'admin'): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-users me-1"></i> Kelola User
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#"><i class="fas fa-user-shield me-2"></i>Admin</a></li>
                            <li><a class="dropdown-item" href="#"><i class="fas fa-chalkboard-teacher me-2"></i>Guru</a></li>
                            <li><a class="dropdown-item" href="#"><i class="fas fa-user-graduate me-2"></i>Siswa</a></li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">
                            <i class="fas fa-tasks me-1"></i> Kelola Ujian
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">
                            <i class="fas fa-chart-line me-1"></i> Laporan
                        </a>
                    </li>
                    
                    <?php elseif(isset($user_type) && $user_type == 'guru'): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="#">
                            <i class="fas fa-plus-circle me-1"></i> Buat Ujian
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">
                            <i class="fas fa-list me-1"></i> Daftar Ujian
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">
                            <i class="fas fa-chart-bar me-1"></i> Hasil Ujian
                        </a>
                    </li>
                    
                    <?php elseif(isset($user_type) && $user_type == 'siswa'): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="#">
                            <i class="fas fa-clipboard-list me-1"></i> Ujian Tersedia
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">
                            <i class="fas fa-history me-1"></i> Riwayat Ujian
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
                
                <ul class="navbar-nav">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" role="button" data-bs-toggle="dropdown">
                            <div class="user-avatar">
                                <i class="fas fa-user"></i>
                            </div>
                            <div class="d-flex flex-column align-items-start">
                                <span><?= isset($user_name) ? htmlspecialchars($user_name) : 'User' ?></span>
                                <?php if(isset($user_type)): ?>
                                    <small class="text-light opacity-75"><?= ucfirst($user_type) ?></small>
                                <?php endif; ?>
                            </div>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="#"><i class="fas fa-user-edit me-2"></i>Profile</a></li>
                            <li><a class="dropdown-item" href="#"><i class="fas fa-cog me-2"></i>Pengaturan</a></li>
                            <?php if(isset($user_type) && $user_type == 'siswa'): ?>
                            <li><a class="dropdown-item" href="#"><i class="fas fa-trophy me-2"></i>Nilai Saya</a></li>
                            <?php endif; ?>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item text-danger" href="<?= isset($base_url) ? $base_url . 'auth/logout' : '#' ?>" onclick="return confirm('Apakah Anda yakin ingin logout?')">
                                <i class="fas fa-sign-out-alt me-2"></i>Logout
                            </a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    
    <!-- Flash Message Display -->
    <?php if(isset($this) && method_exists($this, 'session') && $this->session->flashdata('message')): ?>
    <div class="container-fluid" style="margin-top: 76px;">
        <div class="row">
            <div class="col-12">
                <div class="alert alert-dismissible fade show m-3" role="alert">
                    <?= $this->session->flashdata('message') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <!-- Alternative flash message for simple arrays -->
    <?php if(isset($flash_message)): ?>
    <div class="container-fluid" style="margin-top: 76px;">
        <div class="row">
            <div class="col-12">
                <div class="alert alert-<?= isset($flash_type) ? $flash_type : 'info' ?> alert-dismissible fade show m-3" role="alert">
                    <i class="fas fa-<?= isset($flash_type) && $flash_type == 'success' ? 'check-circle' : (isset($flash_type) && $flash_type == 'danger' ? 'exclamation-triangle' : 'info-circle') ?> me-2"></i>
                    <?= htmlspecialchars($flash_message) ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <!-- Main Content Container -->
    <div class="main-content">

    <!-- Bootstrap JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JavaScript -->
    <script>
        // Auto hide alerts after 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                if (!alert.classList.contains('alert-permanent')) {
                    setTimeout(function() {
                        if (alert && alert.parentNode) {
                            const bsAlert = new bootstrap.Alert(alert);
                            bsAlert.close();
                        }
                    }, 5000);
                }
            });
        });
        
        // Update footer server time
        function updateFooterServerTime() {
            const now = new Date();
            const timeString = now.toLocaleString('id-ID', {
                year: 'numeric',
                month: '2-digit',
                day: '2-digit',
                hour: '2-digit',
                minute: '2-digit',
                second: '2-digit',
                hour12: false
            });
            const timeElement = document.getElementById('footerServerTime');
            if (timeElement) {
                timeElement.textContent = timeString;
            }
        }
        
        // Update time every second
        document.addEventListener('DOMContentLoaded', function() {
            updateFooterServerTime();
            setInterval(updateFooterServerTime, 1000);
        });
        
        // Confirm logout
        document.addEventListener('DOMContentLoaded', function() {
            const logoutLinks = document.querySelectorAll('a[href*="logout"]');
            logoutLinks.forEach(function(link) {
                if (!link.hasAttribute('onclick')) {
                    link.addEventListener('click', function(e) {
                        if (!confirm('Apakah Anda yakin ingin logout?')) {
                            e.preventDefault();
                        }
                    });
                }
            });
        });
        
        // Sidebar toggle for mobile (if sidebar exists)
        document.addEventListener('DOMContentLoaded', function() {
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            
            if (sidebarToggle && sidebar) {
                sidebarToggle.addEventListener('click', function() {
                    sidebar.classList.toggle('show');
                });
                
                // Close sidebar when clicking outside on mobile
                document.addEventListener('click', function(event) {
                    if (window.innerWidth <= 768 && 
                        !sidebar.contains(event.target) && 
                        !sidebarToggle.contains(event.target) && 
                        sidebar.classList.contains('show')) {
                        sidebar.classList.remove('show');
                    }
                });
            }
        });
        
        // Add smooth scrolling for anchor links
        document.addEventListener('DOMContentLoaded', function() {
            const anchorLinks = document.querySelectorAll('a[href^="#"]');
            anchorLinks.forEach(function(link) {
                link.addEventListener('click', function(e) {
                    const href = this.getAttribute('href');
                    if (href !== '#' && href !== '#!') {
                        const target = document.querySelector(href);
                        if (target) {
                            e.preventDefault();
                            target.scrollIntoView({
                                behavior: 'smooth',
                                block: 'start'
                            });
                        }
                    }
                });
            });
        });
        
        // Add loading state to buttons
        document.addEventListener('DOMContentLoaded', function() {
            const buttons = document.querySelectorAll('button[type="submit"], .btn-submit');
            buttons.forEach(function(button) {
                button.addEventListener('click', function() {
                    if (this.type === 'submit' || this.classList.contains('btn-submit')) {
                        this.disabled = true;
                        const originalText = this.innerHTML;
                        this.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Processing...';
                        
                        // Re-enable after 3 seconds as fallback
                        setTimeout(() => {
                            this.disabled = false;
                            this.innerHTML = originalText;
                        }, 3000);
                    }
                });
            });
        });
        
        // Show notification function
        function showNotification(type, message, duration = 5000) {
            const alertDiv = document.createElement('div');
            alertDiv.className = `alert alert-${type} alert-dismissible fade show position-fixed`;
            alertDiv.style.cssText = 'top: 90px; right: 20px; z-index: 9999; min-width: 300px; max-width: 500px;';
            alertDiv.innerHTML = `
                <i class="fas fa-${type === 'success' ? 'check-circle' : type === 'danger' ? 'exclamation-triangle' : 'info-circle'} me-2"></i>
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            
            document.body.appendChild(alertDiv);
            
            setTimeout(() => {
                if (alertDiv && alertDiv.parentNode) {
                    alertDiv.remove();
                }
            }, duration);
            
            return alertDiv;
        }
        
        // Global error handler for AJAX requests
        window.addEventListener('unhandledrejection', function(event) {
            console.error('Unhandled promise rejection:', event.reason);
            showNotification('danger', 'Terjadi kesalahan sistem. Silakan coba lagi.');
        });
    </script>
    
    <!-- Additional custom scripts can be added here -->
    <?php if(isset($additional_js)): ?>
        <?= $additional_js ?>
    <?php endif; ?>
    
</body>
</html>