<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Sistem Ujian Online</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #20c997;
            --sidebar-width: 250px;
            --navbar-height: 60px;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
        }

        /* Top Navigation */
        .top-navbar {
            height: var(--navbar-height);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            display: flex;
            align-items: center;
            padding: 0 20px;
            color: white;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .navbar-brand {
            font-size: 1.5rem;
            font-weight: bold;
            color: white;
            text-decoration: none;
        }

        .navbar-brand:hover {
            color: white;
        }

        .user-menu {
            margin-left: auto;
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .menu-toggle {
            display: none;
            background: none;
            border: none;
            color: white;
            font-size: 1.2rem;
            cursor: pointer;
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 10px;
            color: white;
            text-decoration: none;
            padding: 8px 15px;
            border-radius: 25px;
            background: rgba(255,255,255,0.1);
            transition: all 0.3s ease;
        }

        .user-info:hover {
            background: rgba(255,255,255,0.2);
            color: white;
        }

        .user-avatar {
            width: 35px;
            height: 35px;
            border-radius: 50%;
            background: rgba(255,255,255,0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1rem;
        }

        /* Sidebar */
        .sidebar {
            width: var(--sidebar-width);
            height: calc(100vh - var(--navbar-height));
            background: #2c3e50;
            position: fixed;
            left: 0;
            top: var(--navbar-height);
            overflow-y: auto;
            transition: all 0.3s ease;
            z-index: 999;
        }

        .sidebar-header {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid #34495e;
        }

        .sidebar-logo {
            color: var(--primary-color);
            font-size: 2rem;
            margin-bottom: 10px;
        }

        .sidebar-status {
            color: #ecf0f1;
            font-size: 0.9rem;
        }

        .status-indicator {
            display: inline-block;
            width: 8px;
            height: 8px;
            background: var(--primary-color);
            border-radius: 50%;
            margin-right: 8px;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { opacity: 1; }
            50% { opacity: 0.5; }
            100% { opacity: 1; }
        }

        .sidebar-menu {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .sidebar-menu li {
            border-bottom: 1px solid #34495e;
        }

        .sidebar-menu a {
            display: flex;
            align-items: center;
            padding: 15px 20px;
            color: #bdc3c7;
            text-decoration: none;
            transition: all 0.3s ease;
            font-size: 0.95rem;
        }

        .sidebar-menu a:hover,
        .sidebar-menu a.active {
            background: var(--primary-color);
            color: white;
            padding-left: 30px;
        }

        .sidebar-menu i {
            margin-right: 12px;
            width: 18px;
            text-align: center;
        }

        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            margin-top: var(--navbar-height);
            padding: 20px;
            min-height: calc(100vh - var(--navbar-height));
        }

        /* Welcome Card */
        .welcome-card {
            background: linear-gradient(135deg, #e74c3c, #c0392b);
            color: white;
            border-radius: 10px;
            padding: 25px;
            margin-bottom: 20px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }

        .welcome-card h2 {
            font-size: 1.8rem;
            margin-bottom: 5px;
            font-weight: 600;
        }

        .welcome-card p {
            margin: 0;
            opacity: 0.9;
            font-size: 0.95rem;
        }

        /* Instructions Card */
        .instructions-card {
            background: linear-gradient(135deg, var(--primary-color), #17a589);
            color: white;
            border-radius: 10px;
            padding: 25px;
            margin-bottom: 20px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }

        .instructions-card h4 {
            font-size: 1.3rem;
            margin-bottom: 20px;
            font-weight: 600;
        }

        .instruction-item {
            background: rgba(255,255,255,0.1);
            border-radius: 8px;
            padding: 12px 15px;
            margin-bottom: 10px;
            font-size: 0.9rem;
            line-height: 1.4;
            border-left: 3px solid rgba(255,255,255,0.3);
        }

        .instruction-item:last-child {
            margin-bottom: 0;
        }

        /* Card Styles */
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
        }

        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
        }

        /* Stats Cards */
        .stats-card {
            background: white;
            border-radius: 10px;
            padding: 25px;
            text-align: center;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            height: 100%;
        }

        .stats-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 15px rgba(0,0,0,0.15);
        }

        .stats-number {
            font-size: 2.5rem;
            font-weight: bold;
            background: linear-gradient(135deg, var(--primary-color), #17a589);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 10px;
        }

        /* Button Styles */
        .btn-outline-primary:hover,
        .btn-outline-success:hover,
        .btn-outline-info:hover,
        .btn-outline-warning:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .menu-toggle {
                display: block;
            }

            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.show {
                transform: translateX(0);
            }

            .main-content {
                margin-left: 0;
            }

            .user-info span {
                display: none;
            }

            .welcome-card h2 {
                font-size: 1.5rem;
            }

            .instructions-card h4 {
                font-size: 1.1rem;
            }
        }

        /* Overlay for mobile sidebar */
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: var(--navbar-height);
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.5);
            z-index: 998;
        }

        .sidebar-overlay.show {
            display: block;
        }

        /* Smooth transitions */
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
</head>
<body>
    <!-- Top Navigation -->
    <nav class="top-navbar">
        <button class="menu-toggle" id="menuToggle">
            <i class="fas fa-bars"></i>
        </button>
        
        <a href="#" class="navbar-brand">
            <i class="fas fa-graduation-cap me-2"></i>
            Ujian Online
        </a>
        
        <div class="user-menu">
            <a href="#" class="user-info">
                <span>Halo, a</span>
                <div class="user-avatar">
                    <i class="fas fa-user"></i>
                </div>
                <i class="fas fa-chevron-down"></i>
            </a>
        </div>
    </nav>

    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <div class="sidebar-logo">
                <i class="fas fa-graduation-cap"></i>
            </div>
            <div class="sidebar-status">
                <span class="status-indicator"></span>
                Online
            </div>
        </div>
        
        <ul class="sidebar-menu">
            <li>
                <a href="v_home_guru.php" class="active">
                    <i class="fas fa-home"></i>
                    Home
                </a>
            </li>
            <li>
                <a href="v_penilaian_essay.php">
                    <i class="fas fa-edit"></i>
                    Penilaian Essay
                </a>
            </li>
            <li>
                <a href="<?php echo base_url('guru'); ?>">
                    <i class="fas fa-chalkboard-teacher"></i>
                    Data Guru
                </a>
            </li>
            <li>
                <a href="<?php echo base_url('v_siswa.php'); ?>">
                    <i class="fas fa-user-graduate"></i>
                    Data Siswa
                </a>
            </li>
            <li>
                <a href="v_soal.php">
                    <i class="fas fa-question-circle"></i>
                    Kelola Soal Ujian
                </a>
            </li>
            <li>
                <a href="v_peserta.php">
                    <i class="fas fa-users"></i>
                    Kelola Peserta Ujian
                </a>
            </li>
            <li>
                <a href="v_hasil.php">
                    <i class="fas fa-chart-bar"></i>
                    Hasil Ujian
                </a>
            </li>
            <li>
                <a href="v_jenis_ujian.php">
                    <i class="fas fa-list-alt"></i>
                    Jenis Ujian
                </a>
            </li>
            <li>
                <a href="v_mapel.php">
                    <i class="fas fa-book"></i>
                    Mata Pelajaran
                </a>
            </li>
            <li>
                <a href="v_kelas.php">
                    <i class="fas fa-school"></i>
                    Kelola Kelas
                </a>
            </li>
            <li>
                <a href="v_utilities.php">
                    <i class="fas fa-tools"></i>
                    Utilities
                </a>
            </li>
            <li>
                <a href="v_cetak.php">
                    <i class="fas fa-print"></i>
                    Cetak Laporan
                </a>
            </li>
            <li>
                <a href="v_password.php">
                    <i class="fas fa-key"></i>
                    Ganti Password
                </a>
            </li>
            <li>
                <a href="v_login.php" onclick="return confirm('Apakah Anda yakin ingin keluar?')">
                    <i class="fas fa-sign-out-alt"></i>
                    Keluar Akun
                </a>
            </li>
        </ul>
    </div>

    <!-- Sidebar Overlay for Mobile -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <!-- Main Content -->
    <div class="main-content">
        <div class="fade-in">
            <!-- Welcome Card -->
            <div class="welcome-card">
                <h2>
                    <i class="fas fa-wave-square me-2"></i>
                    Selamat Datang, a
                </h2>
                <p>Level: Admin | Status: Database Online</p>
            </div>

            <!-- Instructions Card -->
            <div class="instructions-card">
                <h4>
                    <i class="fas fa-info-circle me-2"></i>
                    Petunjuk Penggunaan
                </h4>
                
                <div class="instruction-item">
                    <strong>1.</strong> Login Masuk ke halaman login dan gunakan akun admin.
                </div>
                
                <div class="instruction-item">
                    <strong>2.</strong> Kelola Soal Tambah Soal: Pilih jenis (PG, Benar/Salah, atau Essay), isi soal dan simpan. Edit/Hapus Soal: Gunakan tombol edit atau hapus di daftar soal.
                </div>
                
                <div class="instruction-item">
                    <strong>3.</strong> Kelola Ujian Tambah Ujian: Masukkan nama, tanggal, durasi, dan pilih soal. Edit/Hapus: Gunakan tombol yang tersedia di daftar ujian.
                </div>
                
                <div class="instruction-item">
                    <strong>4.</strong> Kelola Siswa Tambah siswa secara manual atau import (jika tersedia). Pastikan siswa memiliki nama, kelas, dan login.
                </div>
                
                <div class="instruction-item">
                    <strong>5.</strong> Lihat Hasil Ujian Buka menu Hasil Ujian untuk melihat nilai siswa. Nilai PG dan Benar/Salah otomatis, Essay harus dinilai manual.
                </div>
                
                <div class="instruction-item">
                    <strong>6.</strong> Penilaian Essay Masuk ke Penilaian Essay. Baca jawaban siswa, beri nilai, lalu klik Simpan.
                </div>
                
                <div class="instruction-item">
                    <strong>7.</strong> Klik tombol Logout setelah selesai.
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4">
                        <div class="card-body">
                            <h5 class="card-title mb-4">
                                <i class="fas fa-bolt me-2 text-warning"></i>
                                Quick Actions
                            </h5>
                            <div class="row g-3">
                                <div class="col-md-3">
                                    <a href="v_siswa_tambah.php" class="btn btn-outline-primary w-100">
                                        <i class="fas fa-user-plus me-2"></i>
                                        Tambah Siswa
                                    </a>
                                </div>
                                <div class="col-md-3">
                                    <a href="v_soal_ujian_tambah.php" class="btn btn-outline-success w-100">
                                        <i class="fas fa-plus me-2"></i>
                                        Tambah Soal
                                    </a>
                                </div>
                                <div class="col-md-3">
                                    <a href="v_jenis_ujian_tambah.php" class="btn btn-outline-info w-100">
                                        <i class="fas fa-clipboard-list me-2"></i>
                                        Buat Ujian
                                    </a>
                                </div>
                                <div class="col-md-3">
                                    <a href="v_cetak.php" class="btn btn-outline-warning w-100">
                                        <i class="fas fa-print me-2"></i>
                                        Cetak Laporan
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="row g-4">
                <div class="col-md-3">
                    <div class="stats-card">
                        <i class="fas fa-users fa-2x mb-3 text-primary"></i>
                        <div class="stats-number">0</div>
                        <p class="text-muted mb-0">Total Siswa</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stats-card">
                        <i class="fas fa-clipboard-list fa-2x mb-3 text-success"></i>
                        <div class="stats-number">0</div>
                        <p class="text-muted mb-0">Total Ujian</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stats-card">
                        <i class="fas fa-question-circle fa-2x mb-3 text-info"></i>
                        <div class="stats-number">0</div>
                        <p class="text-muted mb-0">Total Soal</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stats-card">
                        <i class="fas fa-chart-line fa-2x mb-3 text-warning"></i>
                        <div class="stats-number">0</div>
                        <p class="text-muted mb-0">Total Hasil</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Mobile menu toggle
        const menuToggle = document.getElementById('menuToggle');
        const sidebar = document.getElementById('sidebar');
        const sidebarOverlay = document.getElementById('sidebarOverlay');

        function toggleSidebar() {
            sidebar.classList.toggle('show');
            sidebarOverlay.classList.toggle('show');
        }

        function closeSidebar() {
            sidebar.classList.remove('show');
            sidebarOverlay.classList.remove('show');
        }

        menuToggle.addEventListener('click', toggleSidebar);
        sidebarOverlay.addEventListener('click', closeSidebar);

        // Close sidebar when clicking on menu items on mobile
        const sidebarLinks = document.querySelectorAll('.sidebar-menu a');
        sidebarLinks.forEach(link => {
            link.addEventListener('click', () => {
                if (window.innerWidth <= 768) {
                    closeSidebar();
                }
            });
        });

        // Handle window resize
        window.addEventListener('resize', () => {
            if (window.innerWidth > 768) {
                closeSidebar();
            }
        });

        // Smooth scrolling for better UX
        document.addEventListener('DOMContentLoaded', function() {
            // Add fade-in animation to content
            const content = document.querySelector('.fade-in');
            if (content) {
                content.style.opacity = '0';
                content.style.transform = 'translateY(20px)';
                
                setTimeout(() => {
                    content.style.transition = 'all 0.5s ease';
                    content.style.opacity = '1';
                    content.style.transform = 'translateY(0)';
                }, 100);
            }
        });

        // Add active state management
        const sidebarMenuLinks = document.querySelectorAll('.sidebar-menu a');
        sidebarMenuLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                // Remove active class from all links
                sidebarMenuLinks.forEach(l => l.classList.remove('active'));
                // Add active class to clicked link
                this.classList.add('active');
            });
        });
    </script>
</body>
</html>