<?php $this->load->view('admin/head'); ?>
<?php
$this->load->view('admin/topbar');
$this->load->view('admin/sidebar');
?>

<section class="content">
  <div class="row">
    <div class="col-md-12">
      <?php foreach ($soal as $s) {
        $sid   = (int)$s->id_soal_ujian;
        $is_pg = (trim(strtolower($s->tipe_soal)) === 'pg');
      ?>
      <div class="box box-success" style="overflow-x:auto;">
        <form action="<?= base_url('soal_ujian/update'); ?>" method="post" class="form-horizontal form-soal" data-sid="<?= $sid; ?>">
          <div class="box-header">
            <center><h4 class="box-title">Edit Data</h4></center>
          </div>

          <div class="box-body">
            <input type="hidden" name="id" value="<?= $sid; ?>">

            <div class="form-group">
              <label class="col-sm-2 control-label">Mata Pelajaran</label>
              <div class="col-sm-10">
                <select class="select2 form-control" name="id_matapelajaran" required>
                  <option disabled selected>- Pilih Mata Pelajaran -</option>
                  <?php foreach ($kelas as $a) {
                    $selected = false;
                    if (isset($s->id_matapelajaran) && (string)$s->id_matapelajaran === (string)$a->id_matapelajaran) $selected = true;
                    if (!$selected && isset($s->nama_matapelajaran) && $s->nama_matapelajaran === $a->nama_matapelajaran) $selected = true;
                  ?>
                    <option value="<?= (int)$a->id_matapelajaran; ?>" <?= $selected ? "selected" : ""; ?>>
                      <?= htmlspecialchars($a->kode_matapelajaran, ENT_QUOTES, 'UTF-8'); ?> | <?= htmlspecialchars($a->nama_matapelajaran, ENT_QUOTES, 'UTF-8'); ?>
                    </option>
                  <?php } ?>
                </select>
              </div>
            </div>

            <div class="form-group">
              <label class="col-sm-2 control-label">Tipe Soal</label>
              <div class="col-sm-10">
                <select class="form-control tipe-soal" name="tipe_soal" id="TipeSoal-<?= $sid; ?>" required>
                  <option value="pg"    <?= $is_pg ? 'selected' : ''; ?>>Pilihan Ganda</option>
                  <option value="essay" <?= !$is_pg ? 'selected' : ''; ?>>Non-PG (Esai/Isian)</option>
                </select>
              </div>
            </div>

            <div class="form-group">
              <label class="col-sm-2 control-label">Tulis Soal Ujian</label>
              <div class="col-sm-10">
                <textarea name="soal" id="SoalEditor-<?= $sid; ?>" class="form-control soal" rows="4" required><?= htmlspecialchars($s->pertanyaan, ENT_QUOTES, 'UTF-8'); ?></textarea>
              </div>
            </div>

            <div class="pg-fields" id="PGEdit-<?= $sid; ?>" <?= $is_pg ? '' : 'style="display:none"'; ?>>
              <div class="form-group">
                <label class="col-sm-2 control-label">Jawaban A</label>
                <div class="col-sm-10">
                  <textarea rows="2" class="form-control pg-input" name="a" <?= $is_pg ? 'required' : 'disabled'; ?>><?= htmlspecialchars($s->a, ENT_QUOTES, 'UTF-8'); ?></textarea>
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-2 control-label">Jawaban B</label>
                <div class="col-sm-10">
                  <textarea rows="2" class="form-control pg-input" name="b" <?= $is_pg ? 'required' : 'disabled'; ?>><?= htmlspecialchars($s->b, ENT_QUOTES, 'UTF-8'); ?></textarea>
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-2 control-label">Jawaban C</label>
                <div class="col-sm-10">
                  <textarea rows="2" class="form-control pg-input" name="c" <?= $is_pg ? 'required' : 'disabled'; ?>><?= htmlspecialchars($s->c, ENT_QUOTES, 'UTF-8'); ?></textarea>
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-2 control-label">Jawaban D</label>
                <div class="col-sm-10">
                  <textarea rows="2" class="form-control pg-input" name="d" <?= $is_pg ? 'required' : 'disabled'; ?>><?= htmlspecialchars($s->d, ENT_QUOTES, 'UTF-8'); ?></textarea>
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-2 control-label">Jawaban E</label>
                <div class="col-sm-10">
                  <textarea rows="2" class="form-control pg-input" name="e" <?= $is_pg ? 'required' : 'disabled'; ?>><?= htmlspecialchars($s->e, ENT_QUOTES, 'UTF-8'); ?></textarea>
                </div>
              </div>
              <div class="form-group">
                <label class="col-sm-2 control-label">Kunci Jawaban</label>
                <div class="col-sm-10">
                  <select class="form-control pg-input" name="kunci" <?= $is_pg ? 'required' : 'disabled'; ?>>
                    <?php foreach (['A','B','C','D','E'] as $opt) { ?>
                      <option value="<?= $opt; ?>" <?= ($s->kunci_jawaban === $opt) ? 'selected' : ''; ?>><?= $opt; ?></option>
                    <?php } ?>
                  </select>
                </div>
              </div>
            </div>

            <div class="nonpg-info" id="NonPGEdit-<?= $sid; ?>" <?= $is_pg ? 'style="display:none"' : ''; ?>>
              <div class="form-group">
                <label class="col-sm-2 control-label">Penilaian</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" value="Jawaban dinilai manual (tanpa kunci A–E)" readonly>
                </div>
              </div>
            </div>

            <div class="form-group">
              <label class="col-sm-2 control-label"></label>
              <div class="col-sm-10">
                <button type="button" class="btn btn-default btn-flat" onclick="history.back()"><span class="fa fa-arrow-left"></span> Kembali</button>
                <button type="submit" class="btn btn-primary btn-flat"><span class="fa fa-save"></span> Simpan</button>
              </div>
            </div>
          </div>

          <div class="box-footer"></div>
        </form>
      </div>
      <?php } ?>
    </div>
  </div>
</section>

<?php $this->load->view('admin/js'); ?>

<script>
  $('.select2').select2();
  $('.alert-message, .alert-dismissible').alert().delay(3000).slideUp('slow');

  function toggleById(form){
    var $form = $(form);
    var sid   = $form.data('sid');
    var val   = ($('#TipeSoal-' + sid).val() || '').toString().trim().toLowerCase();
    var isPG  = (val === 'pg');

    $('#PGEdit-' + sid).toggle(isPG);
    $('#NonPGEdit-' + sid).toggle(!isPG);
    $('#PGEdit-' + sid + ' .pg-input').each(function(){
      $(this).prop('required', isPG).prop('disabled', !isPG);
    });
  }

  $('.form-soal').each(function(){
    var form = this;
    toggleById(form);
    $(form).on('change', '#TipeSoal-' + $(form).data('sid'), function(){ toggleById(form); });
  });

  if (window.CKEDITOR) {
    $('.soal').each(function(){
      var id = this.id || ('SoalEditor-' + ($(this).closest('form').data('sid') || Math.random().toString(36).slice(2)));
      this.id = id;
      if (!CKEDITOR.instances[id]) CKEDITOR.replace(id);
    });
  }
</script>

<?php $this->load->view('admin/foot'); ?>
