<?php
$this->load->view('admin/head');
$this->load->view('admin/topbar');
$this->load->view('admin/sidebar');
?>

<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css" />
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.2.0/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
<script src="https://cdn.ckeditor.com/4.22.1/standard/ckeditor.js"></script>

<section class="content">
    <div class="row">
        <div class="col-md-12">
            <?= $this->session->flashdata('message'); ?>
            <div class="box box-success" style="overflow-x: scroll;">
                <div class="box-header">
                    <center><div class="box-title">Tambah Soal Ujian</div></center>
                </div>
                <form action="<?= base_url('soal/insert'); ?>" method="post" id="form-soal">
                    
                    <div class="box-body">
                        <div class="form-horizontal">
                            <div class="form-group">
                                <label class="col-sm-2 control-label">Jenis Soal</label>
                                <div class="col-sm-10">
                                    <select class="form-control" name="tipe_soal" id="tipe_soal" required>
                                        <option value="">- Pilih Jenis Soal -</option>
                                        <option value="pg">Pilihan Ganda</option>
                                        <option value="essay">Essay</option>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-2 control-label">Mata Pelajaran</label>
                                <div class="col-sm-10">
                                    <select class="select2 form-control" name="nama_matapelajaran" required>
                                        <option selected disabled value="">- Pilih Mata Pelajaran -</option>
                                        <?php foreach ($soal as $a): ?>
                                            <option value="<?= $a->id_matapelajaran ?>"><?= $a->kode_matapelajaran ?> | <?= $a->nama_matapelajaran ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-2 control-label">Tulis Soal Ujian</label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" name="pertanyaan" id="pertanyaan" rows="5" required></textarea>
                                </div>
                            </div>

                            <div class="form-group pilihan-ganda">
                                <label class="col-sm-2 control-label">Jawaban A</label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" name="a"></textarea>
                                </div>
                            </div>

                            <div class="form-group pilihan-ganda">
                                <label class="col-sm-2 control-label">Jawaban B</label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" name="b"></textarea>
                                </div>
                            </div>

                            <div class="form-group pilihan-ganda">
                                <label class="col-sm-2 control-label">Jawaban C</label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" name="c"></textarea>
                                </div>
                            </div>

                            <div class="form-group pilihan-ganda">
                                <label class="col-sm-2 control-label">Jawaban D</label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" name="d"></textarea>
                                </div>
                            </div>

                            <div class="form-group pilihan-ganda">
                                <label class="col-sm-2 control-label">Jawaban E</label>
                                <div class="col-sm-10">
                                    <textarea class="form-control" name="e"></textarea>
                                </div>
                            </div>

                            <div class="form-group pilihan-ganda">
                                <label class="col-sm-2 control-label">Kunci Jawaban</label>
                                <div class="col-sm-10">
                                    <select class="form-control" name="kunci">
                                        <option selected disabled value="">- Pilih Kunci Jawaban -</option>
                                        <option>A</option>
                                        <option>B</option>
                                        <option>C</option>
                                        <option>D</option>
                                        <option>E</option>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-2 control-label"></label>
                                <div class="col-sm-10">
                                    <a href="<?= base_url('soal_ujian') ?>" class="btn btn-default btn-flat"><span class="fa fa-arrow-left"></span> Kembali</a>
                                    <button type="submit" class="btn btn-primary btn-flat"><span class="fa fa-save"></span> Simpan</button>
                                </div>
                            </div>

                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

<?php $this->load->view('admin/js'); ?>

<script>

    CKEDITOR.replace( 'pertanyaan', {
    height: 300,
    filebrowserUploadUrl: "soal/upload_image",
    filebrowserUploadMethod: 'form'
    });


    $(document).ready(function() {
        togglePilihanGanda($('#tipe_soal').val());

        $('#tipe_soal').change(function() {
            togglePilihanGanda($(this).val());
        });

        function togglePilihanGanda(tipe) {
            if (tipe === 'essay') {
                $('.pilihan-ganda').hide();
                $('.pilihan-ganda textarea, .pilihan-ganda select').prop('required', false);
            } else {
                $('.pilihan-ganda').show();
                $('.pilihan-ganda textarea, .pilihan-ganda select').prop('required', true);
            }
        }
    });
</script>

<?php $this->load->view('admin/foot'); ?>
<?php $this->load->view('admin/foot'); ?>
