<?php $this->load->view('admin/head'); ?>
<?php $this->load->view('admin/topbar'); ?>
<?php $this->load->view('admin/sidebar'); ?>

<section class="content">
    <div class="row">
        <div class="col-md-12">
            <?= $this->session->flashdata('message'); ?>
            <div class="box box-success" style="overflow-x: scroll;">
                <div class="box-header">
                    <center><h4 class="box-title">Daftar Peserta Ujian</h4></center><p>
                    <a href="<?= base_url('peserta_tambah'); ?>" class="btn btn-primary btn-flat">
                        <span class="fa fa-plus"></span> Tambah
                    </a>
                    <a href="<?= base_url('jenis_ujian'); ?>" class="btn btn-primary btn-flat">
                        Data Jenis Ujian
                    </a>
                </div>

                <div class="box-body" style="overflow-x: scroll;">
                    <table id="data" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th width="1%">No</th>
                                <th>Nama Siswa</th>
                                <th>Kelas</th>
                                <th>Nama Mata Pelajaran</th>
                                <th>Jenis Ujian</th>
                                <th>Waktu Ujian</th>
                                <th>Durasi Ujian</th>
                                <th width="7%">Action</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $no = 1; foreach ($peserta as $d) { ?>
                                <tr>
                                    <td><?= $no++; ?></td>
                                    <td><?= $d->nama_siswa; ?></td>
                                    <td><?= $d->nama_kelas; ?></td>
                                    <td><?= $d->nama_matapelajaran; ?></td>
                                    <td><?= $d->jenis_ujian; ?></td>
                                    <td><?= date('d-m-Y', strtotime($d->tanggal_ujian)); ?> | <?= $d->jam_ujian; ?></td>
                                    <td><?= $d->durasi_ujian; ?> Menit</td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-warning btn-flat btn-xs">Action</button>
                                            <button type="button" class="btn btn-warning btn-xs btn-flat dropdown-toggle" data-toggle="dropdown">
                                                <span class="caret"></span>
                                                <span class="sr-only">Toggle Dropdown</span>
                                            </button>
                                            <ul class="dropdown-menu" role="menu">
                                                <li><a href="<?= base_url('peserta/edit/' . $d->id_peserta); ?>">Edit Data</a></li>
                                                <li><a href="<?= base_url('peserta/hapus/' . $d->id_peserta); ?>" onclick="return confirm('Apakah yakin data peserta ini dihapus?')">Hapus Data</a></li>
                                            </ul>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if ($d->status_ujian == "1") { ?>
                                            <span class="btn btn-xs btn-default">Belum Ujian</span>
                                        <?php } elseif ($d->status_ujian == "2") { ?>
                                            <span class="btn btn-xs btn-success">Selesai Ujian</span>
                                        <?php } ?>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $this->load->view('admin/js'); ?>
<script type="text/javascript">
    $(document).ready(function() {
        $('#data').DataTable({
            buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
        });
        $('.select2').select2();
        $('.alert-message').alert().delay(3000).slideUp('slow');
    });
</script>
<?php $this->load->view('admin/foot'); ?>
