<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Ruang_ujian extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        $this->load->model('m_data'); // Add if not already present
        
        if ($this->session->userdata('status') != 'siswa_login') {
            redirect(base_url().'auth?alert=belum_login');
        }
    }

public function soal()
{
    $id_peserta = $this->uri->segment(3);
    $id = $this->db->query('SELECT * FROM tb_peserta WHERE id_peserta="' . $id_peserta . '"')->row_array();

    // Ambil soal PG dan Essay secara terpisah
    $soal_pg = $this->db->query('SELECT * FROM tb_soal_ujian WHERE id_matapelajaran="' . $id['id_matapelajaran'] . '" AND tipe_soal="pg" ORDER BY RAND()');
    $soal_essay = $this->db->query('SELECT * FROM tb_soal_ujian WHERE id_matapelajaran="' . $id['id_matapelajaran'] . '" AND tipe_soal="essay" ORDER BY RAND()');

    // Gabungkan semua soal
    $semua_soal = array_merge($soal_pg->result(), $soal_essay->result());

    // Ubah status peserta menjadi sedang ujian
    $this->m_data->update_data(
        ['id_peserta' => $id_peserta],
        ['status_ujian_ujian' => 1],
        'tb_peserta'
    );

    $data = array(
        "soal_pg" => $soal_pg->result(),
        "soal_essay" => $soal_essay->result(),
        "soal" => $semua_soal, // PERBAIKAN: Tambahkan ini
        "total_soal_pg" => $soal_pg->num_rows(),
        "total_soal_essay" => $soal_essay->num_rows(),
        "total_soal" => $soal_pg->num_rows() + $soal_essay->num_rows(), // PERBAIKAN: Tambahkan ini
        "max_time" => $id['timer_ujian'],
        "id" => $id
    );

    $this->load->view('ujian/v_soalujian', $data);
}
    public function jawab_aksi()
    {
        $id_peserta = $this->input->post('id_peserta');
        $jumlah     = $this->input->post('jumlah_soal');
        $id_soal    = $this->input->post('soal');
        $jawaban    = $this->input->post('jawaban');

        $data = [];
        for ($i = 0; $i < $jumlah; $i++) {
            $nomor = $id_soal[$i];
            $data[] = array(
                'id_peserta' => $id_peserta,
                'id_soal_ujian' => $nomor,
                'jawaban' => $jawaban[$nomor]
            );
        }

        // Simpan semua jawaban
        $this->db->insert_batch('tb_jawaban', $data);

        // Penilaian otomatis hanya untuk soal PG
        $cek = $this->db->query('SELECT j.id_jawaban, j.jawaban, s.kunci_jawaban, s.tipe_soal 
                                 FROM tb_jawaban j 
                                 JOIN tb_soal_ujian s ON j.id_soal_ujian = s.id_soal_ujian 
                                 WHERE j.id_peserta="' . $id_peserta . '"');

        $benar = 0;
        $salah = 0;

        foreach ($cek->result_array() as $d) {
            $where = $d['id_jawaban'];
            if ($d['tipe_soal'] == 'pg') {
                if ($d['jawaban'] == $d['kunci_jawaban']) {
                    $this->m_data->UpdateNilai($where, ['skor' => 1], 'tb_jawaban');
                    $benar++;
                } else {
                    $this->m_data->UpdateNilai($where, ['skor' => 0], 'tb_jawaban');
                    $salah++;
                }
            }
        }

        // Hitung nilai PG: benar / total soal PG * 100
        $total_soal_pg = $this->db->query('SELECT COUNT(*) as jml FROM tb_jawaban j 
                                           JOIN tb_soal_ujian s ON j.id_soal_ujian = s.id_soal_ujian 
                                           WHERE j.id_peserta="' . $id_peserta . '" AND s.tipe_soal="pg"')->row()->jml;

        $nilai_pg = ($total_soal_pg > 0) ? ($benar / $total_soal_pg) * 100 : 0;

        // Update status ujian dan nilai PG ke tb_peserta
        $this->m_data->UpdateNilai2($id_peserta, [
            'benar' => $benar,
            'salah' => $salah,
            'nilai' => $nilai_pg,
            'status_ujian' => 2,
            'status_ujian_ujian' => 2
        ], 'tb_peserta');

        redirect(base_url('jadwal_ujian'));
    }
}
