<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Peserta extends CI_Controller
{
	public function __construct() {
		parent::__construct();
		$this->load->library('session');

		if ($this->session->userdata('status') != 'admin_login') {
			redirect(base_url('auth'));
		}

		$this->load->model('m_peserta');
		$this->load->model('m_data');
	}

	public function index()
	{
		if (isset($_GET['idkls']) && isset($_GET['idsiswa'])) {
			$idkls = $this->input->get('idkls');
			$idsiswa = $this->input->get('idsiswa');
			$data['peserta'] = $this->m_peserta->get_peserta($idkls, $idsiswa)->result();
		} else if (isset($_GET['idkls'])) {
			$idkls = $this->input->get('idkls');
			$data['peserta'] = $this->m_peserta->get_peserta2($idkls)->result();
		} else if (isset($_GET['idsiswa'])) {
			$idsiswa = $this->input->get('idsiswa');
			$data['peserta'] = $this->m_peserta->get_peserta3($idsiswa)->result();
		} else {
			$data['peserta'] = $this->m_peserta->get_peserta4()->result();
		}

		$data['kelas'] = $this->m_data->get_data('tb_kelas')->result();
		$data['siswa'] = $this->m_data->get_data('tb_siswa')->result();
		$this->load->view('admin/v_peserta', $data);
	}

	public function hapus($id)
	{
		$where = ['id_peserta' => $id];
		$this->m_data->delete_data($where, 'tb_peserta');
		$this->session->set_flashdata('message', '
			<div class="alert alert-danger alert-message">
				<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
				<h4><i class="icon fa fa-check"></i> Data Peserta Ujian berhasil dihapus!</h4>
			</div>');
		redirect(base_url('peserta'));
	}

	public function edit($id)
	{
		$data['peserta'] = $this->m_peserta->get_joinpeserta($id);
		$data['mapel'] = $this->m_data->get_data('tb_matapelajaran')->result();
		$data['siswa'] = $this->m_data->get_data('tb_siswa')->result();
		$data['jenis_ujian'] = $this->m_data->get_data('tb_jenis_ujian')->result();
		$this->load->view('admin/v_peserta_edit', $data);
	}

	public function update()
	{
		$id = $this->input->post('id');
		$data = [
			'id_siswa' => $this->input->post('peserta'),
			'id_matapelajaran' => $this->input->post('mapel'),
			'id_jenis_ujian' => $this->input->post('jenis'),
			'tanggal_ujian' => $this->input->post('tanggal'),
			'jam_ujian' => $this->input->post('jam'),
			'durasi_ujian' => $this->input->post('durasi_ujian'),
			'timer_ujian' => $this->input->post('durasi_ujian') * 60,
			'status_ujian' => 1
		];

		if (in_array('', $data)) {
			$this->session->set_flashdata('message', '
				<div class="alert alert-danger alert-message">
					<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
					<h4><i class="icon fa fa-times"></i> Semua field harus diisi!</h4>
				</div>');
			redirect(base_url('peserta'));
		}

		$this->m_data->update_data(['id_peserta' => $id], $data, 'tb_peserta');
		$this->session->set_flashdata('message', '
			<div class="alert alert-success alert-message">
				<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
				<h4><i class="icon fa fa-check"></i> Data berhasil diperbarui.</h4>
			</div>');
		redirect(base_url('peserta'));
	}
}
